import fs from 'fs';
import path from 'path';
import { fileURLToPath } from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');

const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Startup (Founder)";

const eirUpdates = {
  L0: {
    EiR1: { g1: "I am defensive and lack self-awareness regarding my assumptions.", g5: "I am ruthlessly self-aware and constantly evolve my thinking." },
    EiR2: { g1: "I am blind to obvious risks.", g5: "I see all risks and am fully prepared." },
    EiR3: { g1: "I am certain to experience catastrophic failure.", g5: "I thrive independently and am driven regardless of others." },
    EiR4: { g1: "I would quit immediately.", g5: "I love competition; I thrive on it." },
    EiR5: { g1: "I would abandon the venture immediately.", g5: "I love pivoting; I thrive on change." },
    EiR6: { g1: "I have overlooked multiple critical barriers.", g5: "I have lawyers thoroughly prepping me for all barriers." },
    EiR7: { g1: "No; it is impossible for me to survive.", g5: "I could thrive on my own resources." },
    EiR8: { g1: "I am burning out already.", g5: "My energy is sustainable." },
    EiR9: { g1: "I am clearly chasing hype.", g5: "I have pure authentic purpose." }
  },
  L1: {
    EiR1: { g1: "I assume I am always right.", g5: "I use scientific validation." },
    EiR2: { g1: "I see all risks clearly.", g5: "I am completely blind." },
    EiR3: { g1: "The team is solid.", g5: "The team is crumbling." },
    EiR4: { g1: "There is no competition.", g5: "There is an existential threat." },
    EiR5: { g1: "I am recession-proof; I am strong.", g5: "I would die in a downturn." },
    EiR6: { g1: "There is a clear path; there are no barriers.", g5: "There is a regulatory blockade." },
    EiR7: { g1: "I have low capital needs; I can bootstrap.", g5: "I have a massive capital requirement." },
    EiR8: { g1: "We are fresh and energized.", g5: "We are experiencing severe burnout." },
    EiR9: { g1: "I have healthy validation.", g5: "I have an unhealthy obsession." }
  },
  L2: {
    EiR1: { g1: "I assumed feasibility; it is untested.", g5: "My feasibility is scientifically proven." },
    EiR2: { g1: "I am blind to all debt.", g5: "I have identified all debt." },
    EiR3: { g1: "We have critical weakness.", g5: "We have no gaps." },
    EiR4: { g1: "It is already obsolete.", g5: "It is future-proof." },
    EiR5: { g1: "It is not sustainable.", g5: "It is perpetual." },
    EiR6: { g1: "I have no path; it is chaos.", g5: "I have perfect visibility." },
    EiR7: { g1: "I have no resources.", g5: "I have exceptional resources." },
    EiR8: { g1: "We have severe burnout.", g5: "We are fresh and sustainable." },
    EiR9: { g1: "It is pure ego/hype.", g5: "It is pure mission-driven." }
  },
  L3: {
    EiR1: { g1: "It is assumed and untested.", g5: "It is scientifically validated." },
    EiR2: { g1: "I am blind to competition.", g5: "I have mapped all threats." },
    EiR3: { g1: "The team is falling apart.", g5: "We have excellent cohesion." },
    EiR4: { g1: "I am easily copied; I am doomed.", g5: "It is hard to copy me." },
    EiR5: { g1: "The market is oversaturated; it is dying.", g5: "It is an emerging market." },
    EiR6: { g1: "I am non-compliant; it is illegal.", g5: "I am fully compliant." },
    EiR7: { g1: "It is not sustainable.", g5: "It is highly sustainable." },
    EiR8: { g1: "We have severe burnout.", g5: "We are fresh and energized." },
    EiR9: { g1: "It is artificial traction; fake.", g5: "It is pure organic." }
  },
  L4: {
    EiR1: { g1: "My assumptions are assumed and untested.", g5: "My assumptions are scientifically proven." },
    EiR2: { g1: "I believe I have unlimited growth.", g5: "I face unknown unknowns." },
    EiR3: { g1: "My hiring is lagging badly.", g5: "I attract legendary talent." },
    EiR4: { g1: "My competitors are dormant.", g5: "I face an existential threat." },
    EiR5: { g1: "I believe I thrive in downturns.", g5: "I would die in a recession." },
    EiR6: { g1: "I am blocked internationally.", g5: "I am global ready." },
    EiR7: { g1: "I will never profit.", g5: "I am already profitable." },
    EiR8: { g1: "My team is thriving.", g5: "My team is breaking." },
    EiR9: { g1: "I am driven by pure mission/impact.", g5: "I am driven by pure ego/greed." }
  },
  L5: {
    EiR1: { g1: "My assumptions are assumed and untested.", g5: "My profit model is scientifically proven." },
    EiR2: { g1: "I believe I have unlimited profit potential.", g5: "I face unknown unknowns." },
    EiR3: { g1: "My talent costs are exploding.", g5: "My talent costs are declining relative to revenue." },
    EiR4: { g1: "Prices are rising to my advantage.", g5: "My pricing is under siege." },
    EiR5: { g1: "Fixed costs are dominant.", g5: "My costs are infinitely scalable." },
    EiR6: { g1: "Expectations are unrealistic.", g5: "I am exceeding expectations." },
    EiR7: { g1: "I have no visibility; financials are hidden.", g5: "I have full transparency." },
    EiR8: { g1: "I have a growth obsession only.", g5: "I have a profit obsession." },
    EiR9: { g1: "I am driven by greed only.", g5: "I am driven by pure mission." }
  },
  L6: {
    EiR1: { g1: "My assumptions are assumed and untested.", g5: "My vision is scientifically proven." },
    EiR2: { g1: "I am blind to all risks.", g5: "I have identified all risks." },
    EiR3: { g1: "I have critical gaps.", g5: "I have no gaps." },
    EiR4: { g1: "I am already obsolete.", g5: "I am future-proof." },
    EiR5: { g1: "It is not sustainable.", g5: "It is perpetual." },
    EiR6: { g1: "I have no plan; I have a \"bus factor\" risk.", g5: "I have legendary planning." },
    EiR7: { g1: "I have no investment.", g5: "I have exceptional investment." },
    EiR8: { g1: "I have severe burnout.", g5: "I am fresh and sustainable." },
    EiR9: { g1: "I am driven by pure ego/power.", g5: "I am driven by pure mission." }
  },
  L7: {
    EiR1: { g1: "My assumptions are assumed and untested.", g5: "My assumptions are scientifically proven." },
    EiR2: { g1: "I am blind to all consequences.", g5: "I have identified all consequences." },
    EiR3: { g1: "My ecosystem is fragile.", g5: "My ecosystem is resilient." },
    EiR4: { g1: "My legacy is fragile.", g5: "My legacy is perpetual." },
    EiR5: { g1: "It is unsustainable.", g5: "It is infinitely scalable." },
    EiR6: { g1: "I have no valuation.", g5: "I have exceptional valuation." },
    EiR7: { g1: "I have no impact metrics.", g5: "I have exceptional rigor in metrics." },
    EiR8: { g1: "We have severe exhaustion.", g5: "We are fresh and energized." },
    EiR9: { g1: "I am driven by pure ego/wealth.", g5: "I am driven by pure impact." }
  },
  L8: {
    EiR1: { g1: "My assumptions are assumed and untested.", g5: "My assumptions are scientifically proven." },
    EiR2: { g1: "I am blind to all risks.", g5: "I have identified all risks." },
    EiR3: { g1: "I have major conflicts.", g5: "I have exceptional harmony." },
    EiR4: { g1: "I engage in pure greenwashing.", g5: "I am purely authentic." },
    EiR5: { g1: "I have no measurement.", g5: "I have exceptional rigor." },
    EiR6: { g1: "I have no accountability.", g5: "I have exceptional accountability." },
    EiR7: { g1: "I have no transparency.", g5: "I have full transparency." },
    EiR8: { g1: "I have a toxic culture.", g5: "I have a legendary culture." },
    EiR9: { g1: "I am driven by pure extraction.", g5: "I am driven by pure stewardship." }
  }
};

let updateCount = 0;

for (const [levelId, eirDimensions] of Object.entries(eirUpdates)) {
  if (!answerKeys[levelId]) {
    console.log(`Level ${levelId} not found in answerKeys`);
    continue;
  }
  
  for (const [eirId, grades] of Object.entries(eirDimensions)) {
    if (!answerKeys[levelId].questions?.[eirId]) {
      console.log(`${levelId} ${eirId} not found`);
      continue;
    }
    
    const stakeholderData = answerKeys[levelId].questions[eirId].stakeholders?.[STAKEHOLDER];
    if (!stakeholderData) {
      console.log(`${levelId} ${eirId} - Stakeholder ${STAKEHOLDER} not found`);
      continue;
    }
    
    stakeholderData.grades["1"] = grades.g1;
    stakeholderData.grades["5"] = grades.g5;
    updateCount++;
    
    console.log(`Updated ${levelId} ${eirId}: G1="${grades.g1.substring(0, 40)}..." G5="${grades.g5.substring(0, 40)}..."`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Startup Founder EiR (Risk) entries across all levels.`);
console.log(`File saved to: ${answerKeysPath}`);
