import fs from 'fs';
import path from 'path';
import { fileURLToPath } from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const inputFilePath = path.join(__dirname, '../attached_assets/StartupFounderL0L8Gem_1766573291088.txt');

const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));
const inputText = fs.readFileSync(inputFilePath, 'utf-8');

const STAKEHOLDER = "Startup (Founder)";

const updates = {
  L0: {
    D1: { g1: "I show no evident passion; I treat this venture merely as a job.", g5: "I would do this for free; this problem defines my identity." },
    D2: { g1: "I cannot articulate the problem; my thinking remains vague.", g5: "I tell a transformative story that demonstrates maturity and ecosystem vision." },
    D3: { g1: "I have no awareness of my values, and they are misaligned with this work.", g5: "I have a values-driven identity with complete alignment to the startup culture." },
    D4: { g1: "I have no firsthand experience; I rely on theory only.", g5: "I have lived expertise and possess the depth to mentor others through it." },
    D5: { g1: "I have a full-time job and no bandwidth for this.", g5: "I am all-in; I have restructured my entire life around this commitment." },
    D6: { g1: "I have no unique advantages; I am standard.", g5: "I possess a rare combination of skills/insights that is my unique vantage point." },
    D7: { g1: "I cannot articulate a vision; I offer no inspiration.", g5: "I am a visionary; I inspire movements that people are desperate to join." },
    D8: { g1: "I engage in short-term thinking; my motivation wanes quickly.", g5: "I have a lifelong commitment; I am crisis-resistant." },
    D9: { g1: "I am unwilling to sacrifice or unaware of the need to do so.", g5: "I have made major life changes; I am in a state of all-in sacrifice." }
  },
  L1: {
    D1: { g1: "I have no validation; I rely on theory only.", g5: "Demand exceeds supply; I have proven the problem exists." },
    D2: { g1: "I have done no market analysis.", g5: "I have a sophisticated TAM/SOM/SAM model." },
    D3: { g1: "I ignore feedback; I have a fixed mindset.", g5: "I rapidly iterate based on feedback." },
    D4: { g1: "I have generated no interest; zero.", g5: "I have viral interest; demand is high." },
    D5: { g1: "I am burning fast with no validation.", g5: "I have minimal burn and fully validated spend." },
    D6: { g1: "I have no special skills.", g5: "I have rare founder superpowers." },
    D7: { g1: "I have no transparency; I am hidden.", g5: "I maintain radical transparency on my journey." },
    D8: { g1: "I have no resilience; I quit.", g5: "I bounce back instantly." },
    D9: { g1: "I have no clear positioning.", g5: "I have a unique must-have position." }
  },
  L2: {
    D1: { g1: "I have no MVP; I have a concept only.", g5: "I have a beautiful MVP; it is delightful." },
    D2: { g1: "I have no technical knowledge.", g5: "I have exceptional technical understanding." },
    D3: { g1: "I have no POC; it is speculation.", g5: "I have an exceptional POC." },
    D4: { g1: "I have no customer input.", g5: "I am customer-obsessed." },
    D5: { g1: "I engage in wasteful building.", g5: "I am exceptionally lean." },
    D6: { g1: "I have no differentiation.", g5: "I have exceptional uniqueness." },
    D7: { g1: "I have no validation; I am guessing.", g5: "I have deep validation." },
    D8: { g1: "We have critical gaps; we cannot build.", g5: "I have assembled a dream team." },
    D9: { g1: "I have no iteration; I am stuck.", g5: "I have obsessive iteration." }
  },
  L3: {
    D1: { g1: "I have no revenue; zero users.", g5: "I have rapid growth; clear Product-Market Fit (PMF)." },
    D2: { g1: "I have no customers.", g5: "I have 200+ customers." },
    D3: { g1: "I have no retention; pure churn.", g5: "I have excellent retention." },
    D4: { g1: "I have no virality.", g5: "I have viral growth." },
    D5: { g1: "I am losing on every sale.", g5: "I have excellent margins." },
    D6: { g1: "I have no differentiation; \"me-too\".", g5: "I have unique positioning." },
    D7: { g1: "I have no momentum; I am stalled.", g5: "I have viral momentum." },
    D8: { g1: "I have no moat; I am vulnerable.", g5: "I have a strong, defensible position." },
    D9: { g1: "I have no market position.", g5: "I am the market leader." }
  },
  L4: {
    D1: { g1: "I have no growth; I am plateauing.", g5: "I am experiencing hypergrowth (>100%)." },
    D2: { g1: "I cannot acquire customers; I am stuck.", g5: "I have viral acquisition." },
    D3: { g1: "I have no repeatability; it is random.", g5: "I have a predictable engine." },
    D4: { g1: "I am stuck in one market.", g5: "I am scaling geographically and vertically." },
    D5: { g1: "My economics are negative at scale.", g5: "My economics are exceptional at scale." },
    D6: { g1: "I have no advantage; I am being copied.", g5: "I have a defensible network effect." },
    D7: { g1: "I have no market share.", g5: "I have dominant market share." },
    D8: { g1: "My culture has collapsed.", g5: "My culture has scaled effectively." },
    D9: { g1: "I have no leadership position.", g5: "I am the clear market leader." }
  },
  L5: {
    D1: { g1: "I have negative margins.", g5: "I have outstanding margins (>70%)." },
    D2: { g1: "I have no leverage; growth is linear.", g5: "I have exponential leverage." },
    D3: { g1: "I have negative LTV; I am losing money.", g5: "I have exceptional LTV." },
    D4: { g1: "My CAC > LTV; it is unsustainable.", g5: "I have an exceptional CAC ratio." },
    D5: { g1: "I have high churn; I am bleeding users.", g5: "I have near-zero churn." },
    D6: { g1: "I am cash negative and dying.", g5: "I have exceptional cash reserves." },
    D7: { g1: "I pay wasteful taxes; I am inefficient.", g5: "I have maximized tax efficiency." },
    D8: { g1: "I use capital wastefully.", g5: "I have exceptional capital efficiency." },
    D9: { g1: "I engage in wasteful spending.", g5: "I engage in optimal reinvestment." }
  },
  L6: {
    D1: { g1: "I have no vision; the organization is adrift.", g5: "I have a transformative vision; I am a legend." },
    D2: { g1: "I cannot develop leaders.", g5: "I run a legendary leader factory." },
    D3: { g1: "I have no strategy; I am reactive.", g5: "I have legendary strategic capability." },
    D4: { g1: "I have no innovation; I accept the status quo.", g5: "I am innovation obsessive." },
    D5: { g1: "I cannot scale the organization.", g5: "I have legendary scaling capability." },
    D6: { g1: "I have no trust; the culture is toxic.", g5: "I have built legendary trust." },
    D7: { g1: "I cannot attract talent.", g5: "I attract legendary talent." },
    D8: { g1: "I have no mission; I am lost.", g5: "I am mission obsessed." },
    D9: { g1: "I have no influence; I am unknown.", g5: "I have legendary influence." }
  },
  L7: {
    D1: { g1: "I am building an ordinary company.", g5: "I am building a legendary unicorn." },
    D2: { g1: "I have no legacy; I will be forgotten.", g5: "I have a legendary legacy." },
    D3: { g1: "I have no measurable impact.", g5: "I have transformative impact." },
    D4: { g1: "I cannot inspire.", g5: "I provide legendary inspiration." },
    D5: { g1: "I am local only.", g5: "I am dominant globally." },
    D6: { g1: "I have no disruption.", g5: "I have created a paradigm shift." },
    D7: { g1: "I set no standards.", g5: "I am setting global standards." },
    D8: { g1: "I am isolated; I have no ecosystem.", g5: "I have a legendary ecosystem." },
    D9: { g1: "I create no lasting change.", g5: "I create permanent systemic change." }
  },
  L8: {
    D1: { g1: "I am extractive only.", g5: "I am a legendary steward." },
    D2: { g1: "I serve only myself.", g5: "I maintain legendary balance among stakeholders." },
    D3: { g1: "I ignore the environment.", g5: "I am a legendary steward of the environment." },
    D4: { g1: "I ignore social responsibility.", g5: "I have legendary social impact." },
    D5: { g1: "I have no transparency.", g5: "I have full transparency." },
    D6: { g1: "I am unethical.", g5: "I am an ethical exemplar." },
    D7: { g1: "I exploit the community.", g5: "I am a legendary partner." },
    D8: { g1: "I engage in quarterly thinking.", g5: "I have a generational vision." },
    D9: { g1: "I pay lip service to values.", g5: "My values are embodied." }
  }
};

function interpolateGrades(g1, g5) {
  return {
    "1": g1,
    "2": g1.replace(/^I (have |am |show |cannot |engage in |pay |use |serve |ignore |exploit |create |set )/, (match) => {
      return "I somewhat " + match.substring(2);
    }),
    "3": "I am making progress but still developing in this area.",
    "4": g5.replace(/legendary|exceptional|transformative|outstanding|excellent|viral|obsessive|dominant/gi, "strong"),
    "5": g5
  };
}

let updateCount = 0;

for (const [levelId, dimensions] of Object.entries(updates)) {
  if (!answerKeys[levelId]) continue;
  
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId].questions?.[dimId]) continue;
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders?.[STAKEHOLDER];
    if (!stakeholderData) continue;
    
    stakeholderData.grades["1"] = grades.g1;
    stakeholderData.grades["5"] = grades.g5;
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId}: G1="${grades.g1.substring(0, 50)}..." G5="${grades.g5.substring(0, 50)}..."`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Startup Founder dimension entries across all levels.`);
console.log(`File saved to: ${answerKeysPath}`);
