const fs = require('fs');
const path = require('path');

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Mentor";

const allUpdates = {
  L0: {
    D1: {
      "1": "I offer no safe space; high risk.",
      "2": "I offer a limited space; some risk.",
      "3": "I provide a sandbox for safe learning.",
      "4": "I create a structured, safe environment.",
      "5": "I provide a legendary safe space where founders thrive."
    },
    D2: {
      "1": "I use jargon; I cannot explain simply.",
      "2": "I explain basics but lack simplicity.",
      "3": "I offer clear explanations in simple terms.",
      "4": "I simplify complex concepts expertly.",
      "5": "I can explain anything simply; my clarity is revered."
    },
    D3: {
      "1": "I am closed; I prefer my own solutions.",
      "2": "I am skeptical of external ideas.",
      "3": "I am genuinely open to external ideas.",
      "4": "I actively seek aligned values.",
      "5": "I drive transformation through radical openness."
    },
    D4: {
      "1": "I have no bootstrap experience.",
      "2": "I have read about bootstrapping.",
      "3": "I have real bootstrap experience to share.",
      "4": "I have deep bootstrap expertise.",
      "5": "I am a bootstrap legend; founders love my wisdom."
    },
    D5: {
      "1": "I am expensive; unaffordable for early stage.",
      "2": "I am moderately priced; a stretch.",
      "3": "I offer low-cost help for early stage.",
      "4": "I offer pro-bono or deferred models.",
      "5": "I work for free or equity; I put the founder first."
    },
    D6: {
      "1": "I ignore mental health completely.",
      "2": "I acknowledge stress but offer no tools.",
      "3": "I run a dedicated resilience program.",
      "4": "I integrate therapy-grade support.",
      "5": "I am legendary for founder wellbeing; I transform lives."
    },
    D7: {
      "1": "I punish experimentation; risk-averse.",
      "2": "I tolerate experiments but prefer plans.",
      "3": "I celebrate learning and trials.",
      "4": "I structure experimental learning.",
      "5": "I am legendary for enabling experimentation culture."
    },
    D8: {
      "1": "I am bureaucratic; slow decisions.",
      "2": "I am somewhat responsive but inconsistent.",
      "3": "I have lean processes; I am responsive.",
      "4": "I am highly responsive and agile.",
      "5": "I move lightning-fast; founders praise my speed."
    },
    D9: {
      "1": "I cannot advise on scaling.",
      "2": "I have theoretical scaling knowledge.",
      "3": "I provide practical scaling guidance.",
      "4": "I offer strategic scaling roadmaps.",
      "5": "I am a legendary scaling mentor; I transform trajectories."
    },
    EiR1: {
      "1": "I filter out unconventional founders.",
      "2": "I prefer traditional profiles.",
      "3": "I accept unconventional founders.",
      "4": "I seek out the unconventional.",
      "5": "I search for the unconventional; it is my advantage."
    },
    EiR2: {
      "1": "I have no empathy for frustration.",
      "2": "I get annoyed by founder frustration.",
      "3": "I can address frustration; I listen.",
      "4": "I de-escalate frustration expertly.",
      "5": "I am a legend at difficult conversations; I heal."
    },
    EiR3: {
      "1": "I am bureaucratic and rigid.",
      "2": "I follow rules even when unhelpful.",
      "3": "I am somewhat flexible; I try to help.",
      "4": "I actively minimize bureaucracy.",
      "5": "I am a founder-champion; I remove all red tape."
    },
    EiR4: {
      "1": "I give harmful advice often.",
      "2": "I give generic, unhelpful advice.",
      "3": "I generally give good, specific advice.",
      "4": "I give consistently high-value advice.",
      "5": "I am a legend for transformative, timely advice."
    },
    EiR5: {
      "1": "I am exploiting founders; uncommitted.",
      "2": "I am exploring; loosely committed.",
      "3": "I am genuinely committed to success.",
      "4": "I am a deeply committed partner.",
      "5": "I am a legend for loyalty; I am a lifelong partner."
    },
    EiR6: {
      "1": "I take IP unfairly; predatory.",
      "2": "I request IP shares aggressively.",
      "3": "I have fair IP arrangements.",
      "4": "I support founder IP ownership.",
      "5": "I make founder-friendly deals; I empower them."
    },
    EiR7: {
      "1": "I disappear when they doubt.",
      "2": "I offer platitudes only.",
      "3": "I provide support during doubt.",
      "4": "I guide them through the \"Valley of Death.\"",
      "5": "I am a legend for persistence; I carry them through."
    },
    EiR8: {
      "1": "I am severely burned out.",
      "2": "I am fatigued and cynical.",
      "3": "I am fairly healthy and engaged.",
      "4": "I manage my energy well.",
      "5": "I provide legendary care; I am energized by giving."
    },
    EiR9: {
      "1": "I create dependency; they need me.",
      "2": "I encourage some reliance.",
      "3": "I have a mixed approach.",
      "4": "I coach for self-sufficiency.",
      "5": "I am a legend for creating autonomy; they outgrow me."
    }
  },
  L1: {
    D1: {
      "1": "I cannot validate; no process.",
      "2": "I suggest basic surveys only.",
      "3": "I have a structured validation method.",
      "4": "I guide rigorous customer discovery.",
      "5": "I am a legendary validation mentor."
    },
    D2: {
      "1": "I offer no research support.",
      "2": "I provide Google-level insights.",
      "3": "I provide basic market research help.",
      "4": "I teach advanced market analysis.",
      "5": "I provide legendary market strategies and data."
    },
    D3: {
      "1": "I offer no iteration framework.",
      "2": "I encourage changes randomly.",
      "3": "I have a structured iteration process.",
      "4": "I teach scientific iteration loops.",
      "5": "I am legendary for teaching rapid iteration."
    },
    D4: {
      "1": "My mentees have no traction.",
      "2": "My mentees have anecdotal interest.",
      "3": "Several mentees are gaining traction.",
      "4": "Most mentees find early signal.",
      "5": "I am legendary for helping create traction."
    },
    D5: {
      "1": "I am overloaded and burning out.",
      "2": "I am stretched thin.",
      "3": "I have a manageable load.",
      "4": "I optimize my capacity well.",
      "5": "My load is well-balanced and sustainable."
    },
    D6: {
      "1": "I have no expertise; generic.",
      "2": "I have some general business knowledge.",
      "3": "I have clear early-stage expertise.",
      "4": "I have deep domain expertise.",
      "5": "I am a legend in early-stage dynamics."
    },
    D7: {
      "1": "I give answers only; I do not teach.",
      "2": "I lecture rather than guide.",
      "3": "I have a good teaching approach.",
      "4": "I use Socratic methods effectively.",
      "5": "I am a legendary teacher; they learn to fish."
    },
    D8: {
      "1": "I blame them and disappear.",
      "2": "I am uncomfortable with their failure.",
      "3": "I am a supportive failure coach.",
      "4": "I debrief failure for growth.",
      "5": "I am a legend for building resilience from failure."
    },
    D9: {
      "1": "I offer generic advice only.",
      "2": "I critique but do not solve.",
      "3": "I do good positioning work.",
      "4": "I help craft compelling hooks.",
      "5": "I am a positioning legend; I find the \"wedge.\""
    },
    EiR1: {
      "1": "My advice is often harmful.",
      "2": "My advice is hit-or-miss.",
      "3": "Some advice is helpful; some generic.",
      "4": "My advice is consistently actionable.",
      "5": "I teach them to filter all advice, even mine."
    },
    EiR2: {
      "1": "My clients fail without learning.",
      "2": "Clients struggle; I do not know why.",
      "3": "Several clients struggle; I learn.",
      "4": "I help clients pivot or close gracefully.",
      "5": "Most clients fail, but they learn why (realism)."
    },
    EiR3: {
      "1": "Relationships are toxic/failing.",
      "2": "Relationships are transactional.",
      "3": "Some strains; mostly good.",
      "4": "Relationships are strong and trusted.",
      "5": "Relationships are excellent and lifelong."
    },
    EiR4: {
      "1": "I ignore market shifts.",
      "2": "I am slow to adapt to changes.",
      "3": "I adapt slowly to market needs.",
      "4": "I stay current with trends.",
      "5": "My role evolves ahead of the market."
    },
    EiR5: {
      "1": "I am desperate for income.",
      "2": "I need this to pay bills.",
      "3": "I feel some economic pressure.",
      "4": "I am financially stable.",
      "5": "I am independent; I serve without need."
    },
    EiR6: {
      "1": "I give dangerous legal advice.",
      "2": "I give vague regulatory warnings.",
      "3": "I provide basic guidance; refer out.",
      "4": "I know when to bring in experts.",
      "5": "I offer limited guidance; I am cautious and ethical."
    },
    EiR7: {
      "1": "I charge predatory fees.",
      "2": "I am too expensive for value.",
      "3": "I have moderate, fair costs.",
      "4": "I deliver high value for cost.",
      "5": "I am accessible regardless of cost."
    },
    EiR8: {
      "1": "I am completely burned out.",
      "2": "I am showing signs of fatigue.",
      "3": "I have some fatigue; manageable.",
      "4": "I manage my energy well.",
      "5": "I am fresh, energized, and sustainable."
    },
    EiR9: {
      "1": "I am here for ego/money only.",
      "2": "I am here to build my resume.",
      "3": "I have some self-interest.",
      "4": "I am mostly service-oriented.",
      "5": "I serve with pure, selfless focus."
    }
  },
  L2: {
    D1: {
      "1": "I cannot help; no skills.",
      "2": "I offer general feedback only.",
      "3": "I provide actionable MVP help.",
      "4": "I guide feature prioritization.",
      "5": "I provide legendary building help."
    },
    D2: {
      "1": "I am non-technical; cannot help.",
      "2": "I know buzzwords only.",
      "3": "I provide good technical help.",
      "4": "I can vet architecture/stack.",
      "5": "I provide legendary technical support."
    },
    D3: {
      "1": "I have no framework.",
      "2": "I suggest \"just build it.\"",
      "3": "I have a clear POC framework.",
      "4": "I guide hypothesis-driven POCs.",
      "5": "I have an exceptional framework for proof."
    },
    D4: {
      "1": "I do not do co-design.",
      "2": "I suggest asking users once.",
      "3": "I do some co-design facilitation.",
      "4": "I facilitate deep user collaboration.",
      "5": "I facilitate legendary customer co-creation."
    },
    D5: {
      "1": "My design advice is wasteful.",
      "2": "I focus on features, not value.",
      "3": "My design advice is efficient.",
      "4": "I teach \"lean\" rigorously.",
      "5": "My design approach is exceptionally efficient."
    },
    D6: {
      "1": "My approach is generic.",
      "2": "I copy others' playbooks.",
      "3": "My approach is clear and tailored.",
      "4": "I customize frameworks for them.",
      "5": "My approach is exceptional and bespoke."
    },
    D7: {
      "1": "I provide no education.",
      "2": "I send links to articles.",
      "3": "I provide good context/education.",
      "4": "I teach market dynamics deeply.",
      "5": "I provide exceptional market education."
    },
    D8: {
      "1": "I offer no team support.",
      "2": "I say \"hiring is hard.\"",
      "3": "I offer good hiring support.",
      "4": "I help design org charts/roles.",
      "5": "I offer legendary team development support."
    },
    D9: {
      "1": "My approach is fixed/rigid.",
      "2": "I change my mind randomly.",
      "3": "My approach adapts well.",
      "4": "I teach systematic iteration.",
      "5": "My approach is exceptionally adaptive."
    }
  },
  L3: {
    D1: {
      "1": "My mentees have no revenue.",
      "2": "My mentees have erratic revenue.",
      "3": "My mentees have some revenue.",
      "4": "My mentees have growing revenue.",
      "5": "My mentees are revenue legends."
    },
    D2: {
      "1": "My mentees have no customers.",
      "2": "My mentees have friends/family.",
      "3": "My mentees have some customers.",
      "4": "My mentees have a solid base.",
      "5": "My mentees are legend creators."
    },
    D3: {
      "1": "My mentees are leaving me.",
      "2": "My mentees are disengaged.",
      "3": "My mentees are moderately engaged.",
      "4": "My mentees are highly engaged.",
      "5": "My mentees are evangelists."
    },
    D4: {
      "1": "I have no organic growth help.",
      "2": "I suggest paid ads only.",
      "3": "I have some organic growth tips.",
      "4": "I teach content/viral loops.",
      "5": "I have referral-driven growth mastery."
    },
    D5: {
      "1": "My mentees are failing/broke.",
      "2": "My mentees lose money.",
      "3": "My mentees are breaking even.",
      "4": "My mentees have healthy margins.",
      "5": "My mentees have legend economics."
    },
    D6: {
      "1": "My mentees are generic.",
      "2": "My mentees are \"me-too.\"",
      "3": "My mentees found a clear niche.",
      "4": "My mentees are strongly differentiated.",
      "5": "My mentees are unique category creators."
    },
    D7: {
      "1": "My mentees are failing.",
      "2": "My mentees are stalled.",
      "3": "My mentees are building momentum.",
      "4": "My mentees are accelerating.",
      "5": "My mentees are unstoppable."
    },
    D8: {
      "1": "My mentees are easily copied.",
      "2": "My mentees have weak moats.",
      "3": "My mentees have reasonable moats.",
      "4": "My mentees are building fortresses.",
      "5": "My mentees have legend defensibility."
    },
    D9: {
      "1": "My mentees are followers.",
      "2": "My mentees are insecure.",
      "3": "My mentees are emerging leaders.",
      "4": "My mentees are strong leaders.",
      "5": "My mentees are industry icons."
    }
  },
  L4: {
    D1: {
      "1": "I cannot help them scale.",
      "2": "I offer generic growth hacks.",
      "3": "I help them find some growth.",
      "4": "I provide strategic scaling advice.",
      "5": "I am a growth driver for them."
    },
    D2: {
      "1": "No acquisition help.",
      "2": "Basic acquisition tips.",
      "3": "Some acquisition help.",
      "4": "Strong channel strategy help.",
      "5": "Legend acquisition strategy."
    },
    D3: {
      "1": "No pattern of success.",
      "2": "Success is accidental.",
      "3": "Clear pattern of success.",
      "4": "Systematic growth engines.",
      "5": "Legendary systems of success."
    },
    D4: {
      "1": "No expansion help.",
      "2": "Vague expansion ideas.",
      "3": "Some expansion help.",
      "4": "Strategic market entry help.",
      "5": "Legend expansion playbook."
    },
    D5: {
      "1": "Economics break at scale.",
      "2": "I ignore unit economics.",
      "3": "Economics good at scale.",
      "4": "I optimize economics for scale.",
      "5": "Economics legend at scale."
    },
    D6: {
      "1": "No advantage help.",
      "2": "I ignore competitors.",
      "3": "Growing advantage help.",
      "4": "Strategy to widen the gap.",
      "5": "Legend advantage creation."
    },
    D7: {
      "1": "No position help.",
      "2": "Follower positioning.",
      "3": "Clear position help.",
      "4": "Leadership positioning.",
      "5": "Legend category design."
    },
    D8: {
      "1": "Culture lost in scale.",
      "2": "I ignore culture issues.",
      "3": "Culture healthy scaling.",
      "4": "I teach culture institutionalization.",
      "5": "Legend culture scaling."
    },
    D9: {
      "1": "No trajectory help.",
      "2": "Flat trajectory.",
      "3": "Clear upward trajectory.",
      "4": "Exponential trajectory.",
      "5": "Legend trajectory."
    }
  },
  L5: {
    D1: {
      "1": "No profitability focus.",
      "2": "I focus on top-line only.",
      "3": "Good profitability focus.",
      "4": "I teach margin discipline.",
      "5": "Legendary profitability focus."
    },
    D2: {
      "1": "Inefficient operations.",
      "2": "I accept waste as \"fast.\"",
      "3": "Good efficiency.",
      "4": "I optimize operational flows.",
      "5": "Legendary operations."
    },
    D3: {
      "1": "Losing on mentee value.",
      "2": "Low LTV understanding.",
      "3": "Good LTV focus.",
      "4": "I teach LTV expansion.",
      "5": "Exceptional LTV mastery."
    },
    D4: {
      "1": "CAC > LTV; losing.",
      "2": "I ignore CAC.",
      "3": "Good CAC ratio help.",
      "4": "I optimize CAC/LTV.",
      "5": "Exceptional ratio mastery."
    },
    D5: {
      "1": "High churn accepted.",
      "2": "I focus on new users only.",
      "3": "Low churn focus.",
      "4": "I teach retention mechanics.",
      "5": "Near-zero churn strategies."
    },
    D6: {
      "1": "Negative cash flow.",
      "2": "I ignore cash burn.",
      "3": "Positive cash flow focus.",
      "4": "I teach working capital management.",
      "5": "Cash abundance strategies."
    },
    D7: {
      "1": "No optimization help.",
      "2": "I give bad tax advice.",
      "3": "Good planning referrals.",
      "4": "I understand founder tax needs.",
      "5": "Legend optimization network."
    },
    D8: {
      "1": "Wasteful capital advice.",
      "2": "Spend it to grow it (blindly).",
      "3": "Good productivity advice.",
      "4": "ROI-focused capital allocation.",
      "5": "Exceptional capital productivity."
    },
    D9: {
      "1": "No reinvestment help.",
      "2": "Take profits out too early.",
      "3": "Good reinvestment advice.",
      "4": "Strategic compounding advice.",
      "5": "Legend reinvestment strategy."
    }
  },
  L6: {
    D1: {
      "1": "No leadership growth.",
      "2": "I coach tactics, not people.",
      "3": "Some leadership growth.",
      "4": "I coach executive presence.",
      "5": "Legendary leadership transformation."
    },
    D2: {
      "1": "No mentor growth.",
      "2": "I create followers.",
      "3": "Some becoming leaders.",
      "4": "I build leader-producers.",
      "5": "Legend succession builder."
    },
    D3: {
      "1": "Tactical only.",
      "2": "Short-term strategy.",
      "3": "Good strategy help.",
      "4": "Long-term strategic planning.",
      "5": "Visionary strategy guide."
    },
    D4: {
      "1": "No innovation help.",
      "2": "Maintenance mode advice.",
      "3": "Some innovation help.",
      "4": "I drive innovation culture.",
      "5": "Legendary innovation catalyst."
    },
    D5: {
      "1": "Cannot help scale org.",
      "2": "I create silos.",
      "3": "Good scaling advice.",
      "4": "Organizational design expert.",
      "5": "Legendary organizational architect."
    },
    D6: {
      "1": "Toxic culture allowed.",
      "2": "I ignore culture fit.",
      "3": "Good culture advice.",
      "4": "Values-based culture coaching.",
      "5": "Legendary culture builder."
    },
    D7: {
      "1": "Cannot attract talent.",
      "2": "I hire for skills only.",
      "3": "Good talent advice.",
      "4": "\"A-Player\" attraction strategy.",
      "5": "Legendary talent magnet."
    },
    D8: {
      "1": "No mission focus.",
      "2": "Mission is a poster.",
      "3": "Clear mission alignment.",
      "4": "Mission-driven decision-making.",
      "5": "Legendary mission embodiment."
    },
    D9: {
      "1": "No influence help.",
      "2": "Networking tips only.",
      "3": "Good influence help.",
      "4": "Thought leadership strategy.",
      "5": "Legendary influence builder."
    }
  },
  L7: {
    D1: {
      "1": "No unicorn experience.",
      "2": "I dismiss unicorn goals.",
      "3": "Some unicorn understanding.",
      "4": "I guide towards massive scale.",
      "5": "Legendary unicorn whisperer."
    },
    D2: {
      "1": "No legacy focus.",
      "2": "Short-term exits only.",
      "3": "Clear legacy help.",
      "4": "I help build lasting institutions.",
      "5": "Legendary legacy architect."
    },
    D3: {
      "1": "No impact focus.",
      "2": "Vanity metrics impact.",
      "3": "Clear impact help.",
      "4": "Measurable societal impact.",
      "5": "Transformative impact guide."
    },
    D4: {
      "1": "Cannot inspire.",
      "2": "I inspire momentarily.",
      "3": "Inspiring presence.",
      "4": "Consistently inspiring.",
      "5": "Legendary inspiration source."
    },
    D5: {
      "1": "Local only.",
      "2": "Regional focus.",
      "3": "International help.",
      "4": "Global expansion strategy.",
      "5": "Global presence architect."
    },
    D6: {
      "1": "No disruption help.",
      "2": "Incremental changes.",
      "3": "Clear innovation help.",
      "4": "Industry disruption strategy.",
      "5": "Revolutionary disruption guide."
    },
    D7: {
      "1": "No leadership help.",
      "2": "Management advice.",
      "3": "Clear leadership help.",
      "4": "Industry leadership strategy.",
      "5": "Legendary leadership icon."
    },
    D8: {
      "1": "No ecosystem help.",
      "2": "Transactional network.",
      "3": "Good ecosystem access.",
      "4": "Ecosystem builder.",
      "5": "Legendary ecosystem creator."
    },
    D9: {
      "1": "No systemic change.",
      "2": "Surface level change.",
      "3": "Some systemic change.",
      "4": "Structural change strategy.",
      "5": "Permanent systemic change."
    }
  },
  L8: {
    D1: {
      "1": "No stewardship.",
      "2": "I focus on profit only.",
      "3": "Some stewardship.",
      "4": "I teach responsible ownership.",
      "5": "Legendary stewardship."
    },
    D2: {
      "1": "Only metrics.",
      "2": "Shareholder value only.",
      "3": "Good value balance.",
      "4": "Stakeholder value focus.",
      "5": "Legendary value creation."
    },
    D3: {
      "1": "Extractive mindset.",
      "2": "Compliance only.",
      "3": "Good practices.",
      "4": "Proactive responsibility.",
      "5": "Transformative responsibility."
    },
    D4: {
      "1": "No social impact.",
      "2": "PR-based impact.",
      "3": "Good impact.",
      "4": "Integrated social strategy.",
      "5": "Transformative social change."
    },
    D5: {
      "1": "Hidden/Opaque.",
      "2": "Basic compliance.",
      "3": "Good governance.",
      "4": "Best-practice governance.",
      "5": "Legendary governance."
    },
    D6: {
      "1": "Corrupt/Grey.",
      "2": "Rule-following.",
      "3": "Good ethics.",
      "4": "Values-based ethics.",
      "5": "Legendary ethical standard."
    },
    D7: {
      "1": "Exploits community.",
      "2": "Transactional community.",
      "3": "Good partnership.",
      "4": "Deep community integration.",
      "5": "Transformative community pillar."
    },
    D8: {
      "1": "Quarterly focus.",
      "2": "Annual focus.",
      "3": "5–10 year view.",
      "4": "Generational planning.",
      "5": "Generational wisdom."
    },
    D9: {
      "1": "Values ignored.",
      "2": "Values stated.",
      "3": "Good alignment.",
      "4": "Values lived and enforced.",
      "5": "Legendary alignment."
    },
    EiR1: {
      "1": "Untested/Unknown.",
      "2": "I think I know.",
      "3": "Some understanding.",
      "4": "Deep understanding.",
      "5": "Deep, lived wisdom."
    },
    EiR2: {
      "1": "Blind to ethical risk.",
      "2": "I miss subtle risks.",
      "3": "Know most risks.",
      "4": "I foresee ethical traps.",
      "5": "Expert risk intuition."
    },
    EiR3: {
      "1": "Unhealthy relations.",
      "2": "Transactional relations.",
      "3": "Good health.",
      "4": "Strong stakeholder trust.",
      "5": "Exceptional stakeholder harmony."
    },
    EiR4: {
      "1": "Inauthentic.",
      "2": "Performative.",
      "3": "Mostly authentic.",
      "4": "Highly authentic.",
      "5": "Exceptionally authentic."
    },
    EiR5: {
      "1": "No measurement.",
      "2": "Vanity metrics.",
      "3": "Clear metrics.",
      "4": "Rigorous impact data.",
      "5": "Exceptional impact proof."
    },
    EiR6: {
      "1": "No accountability.",
      "2": "Blame others.",
      "3": "Good accountability.",
      "4": "High personal accountability.",
      "5": "Exceptional accountability culture."
    },
    EiR7: {
      "1": "Hidden.",
      "2": "Selective transparency.",
      "3": "Good balance.",
      "4": "High transparency.",
      "5": "Exceptional transparency."
    },
    EiR8: {
      "1": "Toxic culture.",
      "2": "Stressful culture.",
      "3": "Good culture.",
      "4": "Thriving culture.",
      "5": "Legendary culture of health."
    },
    EiR9: {
      "1": "Pure power.",
      "2": "Ego/Legacy.",
      "3": "Mixed motives.",
      "4": "Service-driven.",
      "5": "Pure stewardship."
    }
  }
};

let updateCount = 0;
let missingCount = 0;

for (const [levelId, dimensions] of Object.entries(allUpdates)) {
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId]) {
      console.log(`Missing level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions) {
      console.log(`Missing questions in level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId]) {
      console.log(`Missing dimension: ${levelId} ${dimId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders) {
      answerKeys[levelId].questions[dimId].stakeholders = {};
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER]) {
      answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER] = {
        question: "",
        grades: {}
      };
    }
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER];
    if (!stakeholderData.grades) {
      stakeholderData.grades = {};
    }
    
    for (const [grade, answer] of Object.entries(grades)) {
      stakeholderData.grades[grade] = answer;
    }
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId} (5 grades)`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Mentor entries with all 5 grades.`);
console.log(`⚠️ Missing entries: ${missingCount}`);
console.log(`Total individual grade updates: ${updateCount * 5}`);
console.log(`File saved to: ${answerKeysPath}`);
