const fs = require('fs');
const path = require('path');

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Influencer/Media";

const allUpdates = {
  L0: {
    D1: {
      "1": "I chase hype; I am late to trends.",
      "2": "I spot trends as they happen.",
      "3": "I identify emerging trends early.",
      "4": "I am ahead of the curve; predictive.",
      "5": "I define trends; I create movements."
    },
    D2: {
      "1": "No credibility; ignored by audience.",
      "2": "Minor credibility; limited following.",
      "3": "Recognized expert; followers trust.",
      "4": "Major credibility; trend-setter status.",
      "5": "I define the discourse; globally recognized."
    },
    D3: {
      "1": "Focuses on exits/drama; ignores early-stage.",
      "2": "Occasional early-stage coverage.",
      "3": "Balanced coverage; some early-stage.",
      "4": "Actively amplifies early-stage founders.",
      "5": "Early-stage narrative champion/leader."
    },
    D4: {
      "1": "No amplification; missed opportunities.",
      "2": "Occasional features; inconsistent.",
      "3": "Regular early-stage coverage.",
      "4": "Actively amplifies; creates virality.",
      "5": "Early-stage champion; launches movements."
    },
    D5: {
      "1": "No audience; shouting into void.",
      "2": "Small niche; limited reach.",
      "3": "Growing audience; relevant reach.",
      "4": "Large audience; trusted platform.",
      "5": "Mega-audience; cultural influence."
    },
    D6: {
      "1": "Generic storytelling; uninspiring.",
      "2": "Some stories; inconsistent quality.",
      "3": "Compelling stories; engaged audience.",
      "4": "Masterful storytelling; movements.",
      "5": "Legend for narratives; inspires generations."
    },
    D7: {
      "1": "Only cover \"standard\" founders (white/male).",
      "2": "Mostly traditional; some diversity.",
      "3": "Diverse founder coverage.",
      "4": "Strong diversity commitment.",
      "5": "Diversity champion; creates space."
    },
    D8: {
      "1": "Burnout visible; declining quality.",
      "2": "Struggling sustainability; drops off.",
      "3": "Sustainable rhythm; consistent.",
      "4": "Thriving rhythm; prolific quality.",
      "5": "Legendary longevity; never burns out."
    },
    D9: {
      "1": "Curated image; never vulnerable.",
      "2": "Carefully controlled; minimal.",
      "3": "Some vulnerability; mostly polished.",
      "4": "Genuinely vulnerable; relatable.",
      "5": "Raw vulnerability; authenticity icon."
    },
    EiR1: {
      "1": "I chase hype; quality suffers.",
      "2": "Mix of hype/substance.",
      "3": "Balanced coverage.",
      "4": "Substance-focused.",
      "5": "Legend for substance; authentic."
    },
    EiR2: {
      "1": "I inflate expectations wildly.",
      "2": "Occasional inflation.",
      "3": "Realistic expectations set.",
      "4": "Carefully manages expectations.",
      "5": "Legend for accuracy and trust."
    },
    EiR3: {
      "1": "I sell coverage; no disclosure.",
      "2": "Sponsored content dominates.",
      "3": "Clear disclosure of ads.",
      "4": "High editorial standards.",
      "5": "Unbought; legendary integrity."
    },
    EiR4: {
      "1": "Irresponsible coverage damages.",
      "2": "Sometimes careless coverage.",
      "3": "Generally responsible coverage.",
      "4": "Careful reputation protection.",
      "5": "Legend for ethical journalism."
    },
    EiR5: {
      "1": "Rapidly losing relevance.",
      "2": "Gradually losing relevance.",
      "3": "Maintaining relevance.",
      "4": "Constantly growing relevance.",
      "5": "Legend for staying relevant."
    },
    EiR6: {
      "1": "Losing many founders.",
      "2": "Losing some founders.",
      "3": "Retaining most founders.",
      "4": "Retaining all founders.",
      "5": "Attracting from everywhere."
    },
    EiR7: {
      "1": "Breaks down easily; defensive.",
      "2": "Gets defensive often.",
      "3": "Can take criticism.",
      "4": "Welcomes criticism.",
      "5": "Thrives on criticism."
    },
    EiR8: {
      "1": "Burnout evident.",
      "2": "Burnout risk present.",
      "3": "Managing sustainability.",
      "4": "Sustainable output.",
      "5": "Prolific and healthy."
    },
    EiR9: {
      "1": "Pure product placement.",
      "2": "Mostly selling products.",
      "3": "Balanced selling/story.",
      "4": "Story-focused journalism.",
      "5": "Pure authentic journalism."
    }
  },
  L1: {
    D1: {
      "1": "I amplify hype; no checking.",
      "2": "I check basics only.",
      "3": "I verify claims with data.",
      "4": "I do deep investigative work.",
      "5": "I am the source of truth."
    },
    D2: {
      "1": "I miss market signals.",
      "2": "I follow crowd sentiment.",
      "3": "I identify real market pull.",
      "4": "I predict market shifts.",
      "5": "I define market reality."
    },
    D3: {
      "1": "I ignore my audience.",
      "2": "I chase likes/views only.",
      "3": "I listen and adapt content.",
      "4": "I co-create with audience.",
      "5": "I lead the audience."
    },
    D4: {
      "1": "I ignore early wins.",
      "2": "I cover them late.",
      "3": "I boost emerging signals.",
      "4": "I make them viral.",
      "5": "I anoint the winners."
    },
    D5: {
      "1": "No revenue; hobby.",
      "2": "Ad-dependent (fragile).",
      "3": "Diversified income.",
      "4": "Strong, independent revenue.",
      "5": "Empire of monetization."
    },
    D6: {
      "1": "Generalist; no focus.",
      "2": "Vague niche.",
      "3": "Clear niche authority.",
      "4": "Dominant voice in niche.",
      "5": "Category King of niche."
    },
    D7: {
      "1": "Entertainment only.",
      "2": "Superficial tips.",
      "3": "Actionable education.",
      "4": "Deep educational value.",
      "5": "The industry textbook."
    },
    D8: {
      "1": "I only show success.",
      "2": "I show curated struggles.",
      "3": "I show real \"build in public\".",
      "4": "I champion the messy middle.",
      "5": "I normalize the struggle."
    },
    D9: {
      "1": "Generic news regurgitation.",
      "2": "Commentary on news.",
      "3": "Unique angles on news.",
      "4": "Original reporting.",
      "5": "Agenda-setting stories."
    },
    EiR1: {
      "1": "Frequent errors/lies.",
      "2": "Occasional inaccuracies.",
      "3": "Corrections issued.",
      "4": "Fact-checked rigor.",
      "5": "Unimpeachable accuracy."
    },
    EiR2: {
      "1": "Audience churning fast.",
      "2": "Engagement dropping.",
      "3": "Stable audience.",
      "4": "Growing audience.",
      "5": "Cult-like following."
    },
    EiR3: {
      "1": "I hear only my side.",
      "2": "I confirm my biases.",
      "3": "I seek diverse views.",
      "4": "I challenge my bubble.",
      "5": "I bridge divides."
    },
    EiR4: {
      "1": "100% algorithm dependent.",
      "2": "High platform risk.",
      "3": "Multi-channel presence.",
      "4": "Owned audience (Email/Community).",
      "5": "Platform-proof brand."
    },
    EiR5: {
      "1": "Will say anything for money.",
      "2": "Heavily influenced.",
      "3": "Independent editorial.",
      "4": "Viewer-supported (Substack).",
      "5": "Financially sovereign."
    },
    EiR6: {
      "1": "Pure clickbait/spam.",
      "2": "Sensationalist headlines.",
      "3": "Engaging but honest.",
      "4": "Value-driven hooks.",
      "5": "Authority-driven traffic."
    },
    EiR7: {
      "1": "Laughing stock.",
      "2": "Questionable reputation.",
      "3": "Respected voice.",
      "4": "Trusted authority.",
      "5": "Voice of God."
    },
    EiR8: {
      "1": "Cannot stop posting.",
      "2": "Exhausted by pace.",
      "3": "Sustainable schedule.",
      "4": "Team supports pace.",
      "5": "Content works while I sleep."
    },
    EiR9: {
      "1": "Secretly paid/biased.",
      "2": "Clear bias.",
      "3": "Transparent bias.",
      "4": "Objective.",
      "5": "Truth-seeker."
    }
  },
  L2: {
    D1: {
      "1": "Chaotic/Missed posts.",
      "2": "Inconsistent schedule.",
      "3": "Reliable publishing.",
      "4": "High-quality production line.",
      "5": "Media factory excellence."
    },
    D2: {
      "1": "Phone only/Basic.",
      "2": "Pro-sumer tools.",
      "3": "Professional stack.",
      "4": "Integrated media stack.",
      "5": "Proprietary tech advantage."
    },
    D3: {
      "1": "Copycat format.",
      "2": "Generic interview/blog.",
      "3": "Signature segment.",
      "4": "Franchiseable format.",
      "5": "Genre-defining format."
    },
    D4: {
      "1": "No engagement.",
      "2": "Reply to comments.",
      "3": "Private community (Discord).",
      "4": "Thriving paid community.",
      "5": "Self-governing movement."
    },
    D5: {
      "1": "Expensive/Slow.",
      "2": "Time-consuming.",
      "3": "Efficient workflow.",
      "4": "High-leverage reuse.",
      "5": "Zero-marginal cost content."
    },
    D6: {
      "1": "Same as everyone.",
      "2": "Slight twist.",
      "3": "Distinct voice.",
      "4": "Uncopyable perspective.",
      "5": "The only one doing it."
    },
    D7: {
      "1": "No insights; noise.",
      "2": "Obvious observations.",
      "3": "Actionable insights.",
      "4": "Proprietary data/analysis.",
      "5": "Market-moving intelligence."
    },
    D8: {
      "1": "Solo grind.",
      "2": "Virtual Assistant.",
      "3": "Producer/Editor team.",
      "4": "Full newsroom/studio.",
      "5": "World-class media organization."
    },
    D9: {
      "1": "Stale/Repetitive.",
      "2": "Trying new things.",
      "3": "Data-driven evolution.",
      "4": "Constant reinvention.",
      "5": "Always ahead of the zeitgeist."
    }
  },
  L3: {
    D1: {
      "1": "No impact.",
      "2": "Small bump.",
      "3": "Significant traffic spike.",
      "4": "Sold out inventory.",
      "5": "Server-crashing demand."
    },
    D2: {
      "1": "Lookie-loos only.",
      "2": "Low conversion.",
      "3": "Solid conversion.",
      "4": "High-intent buyers.",
      "5": "Cult-like purchasing."
    },
    D3: {
      "1": "Skeptical audience.",
      "2": "Cautious trust.",
      "3": "Trusted curator.",
      "4": "\"Buy it now\" trust.",
      "5": "The Oprah Effect."
    },
    D4: {
      "1": "No virality.",
      "2": "Occasional hit.",
      "3": "Consistent sharing.",
      "4": "Engineered virality.",
      "5": "Cultural phenomenon."
    },
    D5: {
      "1": "No sponsors.",
      "2": "One-off deals.",
      "3": "Recurring sponsors.",
      "4": "Long-term partners.",
      "5": "Sponsors waiting list."
    },
    D6: {
      "1": "Noise.",
      "2": "Signal.",
      "3": "Authority.",
      "4": "Celebrity.",
      "5": "Icon."
    },
    D7: {
      "1": "Flat/Declining.",
      "2": "Linear growth.",
      "3": "Compounding growth.",
      "4": "Rocket ship.",
      "5": "Ubiquity."
    },
    D8: {
      "1": "Easily replaced.",
      "2": "Personality moat.",
      "3": "Brand moat.",
      "4": "Community moat.",
      "5": "Unassailable intellectual property."
    },
    D9: {
      "1": "Follower.",
      "2": "Commentator.",
      "3": "Voice.",
      "4": "Leader.",
      "5": "Kingmaker."
    }
  },
  L4: {
    D1: {
      "1": "Solo channel.",
      "2": "Cross-collabs.",
      "3": "Podcast network.",
      "4": "Multi-channel empire.",
      "5": "Media conglomerate."
    },
    D2: {
      "1": "I ignore others.",
      "2": "I fanboy/girl.",
      "3": "I feature guests.",
      "4": "I launch new creators.",
      "5": "I build stars (e.g., Barstool)."
    },
    D3: {
      "1": "Merch only.",
      "2": "Basic course.",
      "3": "Premium subscription.",
      "4": "Software/Tools.",
      "5": "Physical product empire (e.g., Feastables)."
    },
    D4: {
      "1": "Local.",
      "2": "Regional.",
      "3": "National.",
      "4": "International.",
      "5": "Global household name."
    },
    D5: {
      "1": "Margins shrink.",
      "2": "Costs rise with scale.",
      "3": "Healthy margins.",
      "4": "Infinite leverage.",
      "5": "Money-printing machine."
    },
    D6: {
      "1": "Renter (YouTube/X).",
      "2": "Diversified renter.",
      "3": "Owned list (Substack).",
      "4": "Owned app/platform.",
      "5": "Ecosystem owner."
    },
    D7: {
      "1": "No impact.",
      "2": "Niche impact.",
      "3": "Move stock prices.",
      "4": "Shape policy.",
      "5": "Change culture."
    },
    D8: {
      "1": "Toxic/Ego-driven.",
      "2": "Chaotic.",
      "3": "Professional.",
      "4": "Mission-driven.",
      "5": "Cult-like internal culture."
    },
    D9: {
      "1": "Fading fast.",
      "2": "Holding on.",
      "3": "Career creator.",
      "4": "Institution.",
      "5": "Legacy brand."
    }
  },
  L5: {
    D1: {
      "1": "Low margins.",
      "2": "Average margins.",
      "3": "High media margins.",
      "4": "Tech-like margins.",
      "5": "Pure profit leverage."
    },
    D2: {
      "1": "Manual grind.",
      "2": "Delegated tasks.",
      "3": "Systematized.",
      "4": "Automated/Artificial intelligence-driven.",
      "5": "Invisible operations."
    },
    D3: {
      "1": "Low value/fan.",
      "2": "Ad revenue only.",
      "3": "High value (Products).",
      "4": "Lifetime recurring.",
      "5": "Generational value."
    },
    D4: {
      "1": "Paid ads to grow.",
      "2": "High effort organic.",
      "3": "Low effort organic.",
      "4": "Negative customer acquisition cost (Viral).",
      "5": "Audience finds me."
    },
    D5: {
      "1": "High churn.",
      "2": "Rotate audience.",
      "3": "Loyal core.",
      "4": "Lifelong fans.",
      "5": "Multi-generational fans."
    },
    D6: {
      "1": "Lumpy/Unpredictable.",
      "2": "Seasonal.",
      "3": "Predictable.",
      "4": "Abundant.",
      "5": "War chest."
    },
    D7: {
      "1": "Freelancer.",
      "2": "Limited liability company.",
      "3": "Optimized corporate structure.",
      "4": "Holding company.",
      "5": "Global tax structure."
    },
    D8: {
      "1": "Spend it all.",
      "2": "Save in bank.",
      "3": "Angel invest.",
      "4": "Venture fund (Creator fund).",
      "5": "Market mover/Whale."
    },
    D9: {
      "1": "No reinvestment.",
      "2": "Upgrade gear.",
      "3": "Hire team.",
      "4": "Acquire competitors.",
      "5": "Build ecosystem."
    }
  },
  L6: {
    D1: {
      "1": "Next video.",
      "2": "Next year.",
      "3": "5-year plan.",
      "4": "Industry vision.",
      "5": "Cultural visionary."
    },
    D2: {
      "1": "Participant.",
      "2": "Complainer.",
      "3": "Advocate.",
      "4": "Unionizer/Leader.",
      "5": "Patron Saint of creators."
    },
    D3: {
      "1": "Copycat.",
      "2": "Remix.",
      "3": "Innovator.",
      "4": "Pioneer.",
      "5": "Genre creator."
    },
    D4: {
      "1": "Unethical.",
      "2": "Grey areas.",
      "3": "Ethical.",
      "4": "Ethics standard bearer.",
      "5": "Moral compass."
    },
    D5: {
      "1": "Solitary.",
      "2": "Networker.",
      "3": "Super-connector.",
      "4": "Ecosystem hub.",
      "5": "The \"room\" where it happens."
    },
    D6: {
      "1": "Toxic comments.",
      "2": "Moderated.",
      "3": "Safe space.",
      "4": "Inclusive haven.",
      "5": "Radical belonging."
    },
    D7: {
      "1": "Competitive.",
      "2": "Transactional.",
      "3": "Win-win.",
      "4": "Rising tide lifts all.",
      "5": "Ecosystem abundance."
    },
    D8: {
      "1": "Victim of algorithm.",
      "2": "Adapter.",
      "3": "Beta tester.",
      "4": "Partner/Advisor.",
      "5": "Board member/Owner."
    },
    D9: {
      "1": "Noise.",
      "2": "Opinion.",
      "3": "Expert.",
      "4": "Authority.",
      "5": "Gospel."
    }
  },
  L7: {
    D1: {
      "1": "No impact.",
      "2": "Memes.",
      "3": "Trends.",
      "4": "Shifts.",
      "5": "Eras defined."
    },
    D2: {
      "1": "Digital dust.",
      "2": "Archives.",
      "3": "A body of work.",
      "4": "A media institution.",
      "5": "A philosophy/School of thought."
    },
    D3: {
      "1": "Broke.",
      "2": "Middle class.",
      "3": "Wealthy.",
      "4": "Rich.",
      "5": "Dynasty."
    },
    D4: {
      "1": "None.",
      "2": "A few copycats.",
      "3": "Many followers.",
      "4": "A generation of creators.",
      "5": "The blueprint for the industry."
    },
    D5: {
      "1": "Unknown.",
      "2": "Famous in niche.",
      "3": "Famous in country.",
      "4": "World famous.",
      "5": "Historical figure."
    },
    D6: {
      "1": "Ignored by television.",
      "2": "Featured on television.",
      "3": "Competing with television.",
      "4": "Replacing television.",
      "5": "Killed television."
    },
    D7: {
      "1": "Low quality.",
      "2": "Good quality.",
      "3": "High quality.",
      "4": "New standard.",
      "5": "The gold standard."
    },
    D8: {
      "1": "Selfish.",
      "2": "Helping friends.",
      "3": "Mentoring.",
      "4": "Launching careers.",
      "5": "Creating industries."
    },
    D9: {
      "1": "One-hit wonder.",
      "2": "Faded star.",
      "3": "Relevant veteran.",
      "4": "Madonna/Bowie level.",
      "5": "Timeless."
    }
  },
  L8: {
    D1: {
      "1": "Reckless.",
      "2": "Careful.",
      "3": "Responsible.",
      "4": "Accountable.",
      "5": "Steward of truth."
    },
    D2: {
      "1": "Clickbait/Waste.",
      "2": "Entertainment.",
      "3": "Education/Insight.",
      "4": "Wisdom.",
      "5": "Enlightenment/Progress."
    },
    D3: {
      "1": "Promote waste/consumerism.",
      "2": "Neutral.",
      "3": "Aware.",
      "4": "Advocate.",
      "5": "Change agent."
    },
    D4: {
      "1": "Ignore issues.",
      "2": "Performative posting.",
      "3": "Fundraiser.",
      "4": "Activist.",
      "5": "Humanitarian."
    },
    D5: {
      "1": "Shady deals.",
      "2": "Compliant.",
      "3": "Transparent.",
      "4": "Ethical governance.",
      "5": "Model organization."
    },
    D6: {
      "1": "Sold out.",
      "2": "Compromised.",
      "3": "Principled.",
      "4": "Unbought.",
      "5": "Incorruptible."
    },
    D7: {
      "1": "Take.",
      "2": "Trade.",
      "3": "Give.",
      "4": "Empower.",
      "5": "Endow."
    },
    D8: {
      "1": "Today's views.",
      "2": "This year's sponsor.",
      "3": "10-year brand.",
      "4": "Lifetime legacy.",
      "5": "Future of humanity."
    },
    D9: {
      "1": "Spread rumors.",
      "2": "Verify facts.",
      "3": "Seek truth.",
      "4": "Speak truth to power.",
      "5": "Guardian of reality."
    }
  }
};

let updateCount = 0;
let missingCount = 0;

for (const [levelId, dimensions] of Object.entries(allUpdates)) {
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId]) {
      console.log(`Missing level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions) {
      console.log(`Missing questions in level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId]) {
      console.log(`Missing dimension: ${levelId} ${dimId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders) {
      answerKeys[levelId].questions[dimId].stakeholders = {};
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER]) {
      answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER] = {
        question: "",
        grades: {}
      };
    }
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER];
    if (!stakeholderData.grades) {
      stakeholderData.grades = {};
    }
    
    for (const [grade, answer] of Object.entries(grades)) {
      stakeholderData.grades[grade] = answer;
    }
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId} (5 grades)`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Influencer/Media entries with all 5 grades.`);
console.log(`⚠️ Missing entries: ${missingCount}`);
console.log(`Total individual grade updates: ${updateCount * 5}`);
console.log(`File saved to: ${answerKeysPath}`);
