const fs = require('fs');
const path = require('path');

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Government/Policy";

const allUpdates = {
  L0: {
    D1: {
      "1": "We offer no safety nets; risk is punitive.",
      "2": "We have limited nets; perceived risk is high.",
      "3": "We offer clear safety nets for early-stage.",
      "4": "We have strong nets; measurable risk reduction.",
      "5": "We provide comprehensive safety; culture shift."
    },
    D2: {
      "1": "We view startups as risky/niche only.",
      "2": "We acknowledge importance but lack depth.",
      "3": "We clearly articulate value; policy aligned.",
      "4": "We show deep commitment; policy designed.",
      "5": "Entrepreneurship is central to our national vision."
    },
    D3: {
      "1": "We create barriers; unhelpful policies.",
      "2": "We are neutral at best; barriers remain.",
      "3": "We remove key barriers effectively.",
      "4": "We have comprehensive barrier removal.",
      "5": "Our policy is designed entirely around founders."
    },
    D4: {
      "1": "No ecosystem support; unhelpful history.",
      "2": "Limited support; minimal impact.",
      "3": "Real support given; some successes.",
      "4": "Proven ecosystem support; growth.",
      "5": "Legendary ecosystem builder; transformative."
    },
    D5: {
      "1": "No grants; no incentives.",
      "2": "Minimal incentives; unclear process.",
      "3": "Clear grants; some support available.",
      "4": "Substantial grants; accessible.",
      "5": "Major grants; transformative incentives."
    },
    D6: {
      "1": "No unique levers; generic approach.",
      "2": "Standard tools; limited impact.",
      "3": "Some unique levers; meaningful impact.",
      "4": "Unique policy combinations; powerful.",
      "5": "Policy innovator; creates competitive advantage."
    },
    D7: {
      "1": "We punish failure; discourages risk.",
      "2": "Neutral on failure; risk-averse.",
      "3": "We recognize learning from failure.",
      "4": "We celebrate failures; public support.",
      "5": "Failure is expected; part of our culture."
    },
    D8: {
      "1": "Programs halt with regime change.",
      "2": "Vulnerable to politics; disruption risk.",
      "3": "Some continuity; mostly stable.",
      "4": "Program continuity; political-proof.",
      "5": "Bipartisan support; permanent institutions."
    },
    D9: {
      "1": "Short-term thinking; election-driven.",
      "2": "Mostly short-term; some long-term.",
      "3": "Long-term focused; ecosystem view.",
      "4": "Deep long-term commitment; strategic.",
      "5": "Legendary ecosystem builder; generational vision."
    },
    EiR1: {
      "1": "Innovation is purely political theater.",
      "2": "Mostly political; some substance.",
      "3": "Balanced politics and real needs.",
      "4": "Substance-driven; politics managed.",
      "5": "Innovation transcends politics."
    },
    EiR2: {
      "1": "System enables cronies easily.",
      "2": "Some favoritism exists.",
      "3": "Mostly fair allocation.",
      "4": "Rigorous fairness mechanisms.",
      "5": "Legendary integrity; blind to bias."
    },
    EiR3: {
      "1": "No empathy; we are the bureaucracy.",
      "2": "Somewhat understanding; slow change.",
      "3": "Good at reducing friction.",
      "4": "Actively removes bureaucracy.",
      "5": "Founder-champion; zero red tape."
    },
    EiR4: {
      "1": "Criteria highly biased; exclusionary.",
      "2": "Some unconscious bias exists.",
      "3": "Relatively unbiased criteria.",
      "4": "Carefully unbiased selection.",
      "5": "Legend for fair inclusion; diversity native."
    },
    EiR5: {
      "1": "Immediately bows to politics.",
      "2": "Quickly compromises under pressure.",
      "3": "Resists most political pressure.",
      "4": "Stands firm on values.",
      "5": "Legend for political courage."
    },
    EiR6: {
      "1": "Yes; rapidly becoming irrelevant.",
      "2": "Possibly losing relevance.",
      "3": "Maintaining relevance.",
      "4": "Growing relevance.",
      "5": "Legend for staying ahead of curve."
    },
    EiR7: {
      "1": "No funding for risk; safe bets only.",
      "2": "Minimal risk funding.",
      "3": "Some risk funding.",
      "4": "Generous risk funding.",
      "5": "We bankroll the impossible."
    },
    EiR8: {
      "1": "Staff frustrated/cynical.",
      "2": "Some staff frustration.",
      "3": "Mostly inspired staff.",
      "4": "Well-inspired, energetic staff.",
      "5": "Legendary staff culture; mission-driven."
    },
    EiR9: {
      "1": "Pure politics/optics.",
      "2": "Mostly optics; some help.",
      "3": "Balanced public good.",
      "4": "Authentic public service.",
      "5": "Pure ecosystem stewardship."
    }
  },
  L1: {
    D1: {
      "1": "We assume needs; ivory tower.",
      "2": "We do basic surveys.",
      "3": "We run citizen discovery interviews.",
      "4": "We use data-driven needs analysis.",
      "5": "We predict needs before they arise."
    },
    D2: {
      "1": "We ignore market gaps.",
      "2": "We see gaps but do not act.",
      "3": "We identify clear market failures.",
      "4": "We design interventions for gaps.",
      "5": "We fix systemic market failures."
    },
    D3: {
      "1": "No pilots; full rollouts only.",
      "2": "Hesitant to pilot; fear of failure.",
      "3": "We have a pilot framework.",
      "4": "We aggressively pilot new ideas.",
      "5": "We are a \"Testbed Nation/City.\""
    },
    D4: {
      "1": "We ignore startups.",
      "2": "We have occasional meetings.",
      "3": "We have structured roundtables.",
      "4": "We co-create policy with startups.",
      "5": "Startups draft policy with us."
    },
    D5: {
      "1": "Data is locked/paper-based.",
      "2": "Data is digital but hard to get.",
      "3": "Open data portals exist.",
      "4": "API-first government data.",
      "5": "Data is a platform for innovation."
    },
    D6: {
      "1": "Impossible; RFPs exclude startups.",
      "2": "Very difficult; waivers needed.",
      "3": "Simplified procurement track.",
      "4": "Dedicated startup procurement.",
      "5": "We are the first customer of choice."
    },
    D7: {
      "1": "We are behind the curve.",
      "2": "We react to trends late.",
      "3": "We monitor emerging tech.",
      "4": "We anticipate tech shifts.",
      "5": "We shape global tech regulation."
    },
    D8: {
      "1": "We ignore complaints.",
      "2": "Feedback goes into a black hole.",
      "3": "We have feedback channels.",
      "4": "We act on feedback quickly.",
      "5": "Real-time, transparent responsiveness."
    },
    D9: {
      "1": "RFPs specify exact solutions (rigid).",
      "2": "RFPs are solution-biased.",
      "3": "RFPs are outcome-based.",
      "4": "RFPs define problems, not solutions.",
      "5": "Challenge-based procurement (GovTech)."
    },
    EiR1: {
      "1": "We buy \"shiny objects.\"",
      "2": "We follow tech hype.",
      "3": "We map tech to problems.",
      "4": "We are rigorously problem-led.",
      "5": "We validate the \"Why\" before the \"What.\""
    },
    EiR2: {
      "1": "We design for the majority only.",
      "2": "We overlook marginalized groups.",
      "3": "We try to be inclusive.",
      "4": "We design for the margins.",
      "5": "Radical inclusion is our standard."
    },
    EiR3: {
      "1": "Policy written by incumbents.",
      "2": "We hear mostly big players.",
      "3": "We balance stakeholder views.",
      "4": "We prioritize challenger voices.",
      "5": "We have a level playing field."
    },
    EiR4: {
      "1": "Pilots never scale.",
      "2": "Pilots rarely scale.",
      "3": "Path to scale is defined.",
      "4": "High pilot-to-production rate.",
      "5": "Pilots are pre-contracts."
    },
    EiR5: {
      "1": "Fear paralyzes all action.",
      "2": "We avoid controversial topics.",
      "3": "We manage public relations risks.",
      "4": "We embrace necessary risk.",
      "5": "We control the narrative through transparency."
    },
    EiR6: {
      "1": "Innovation dies in committee.",
      "2": "Slow decision-making.",
      "3": "Reasonable timelines.",
      "4": "Startup-speed decisions.",
      "5": "Governance at the speed of tech."
    },
    EiR7: {
      "1": "Policy makers are tech-illiterate.",
      "2": "Some tech knowledge.",
      "3": "Tech advisors involved.",
      "4": "Tech-savvy leadership.",
      "5": "Technocrats drive policy."
    },
    EiR8: {
      "1": "Legal blocks everything.",
      "2": "Legal is a bottleneck.",
      "3": "Legal tries to help.",
      "4": "Legal finds the path.",
      "5": "Legal innovates frameworks."
    },
    EiR9: {
      "1": "Agencies war with each other.",
      "2": "Agencies are disconnected.",
      "3": "Some cross-agency work.",
      "4": "Collaborative governance.",
      "5": "Whole-of-government approach."
    }
  },
  L2: {
    D1: {
      "1": "Paper-based/Legacy.",
      "2": "Digitization in progress.",
      "3": "Digital services available.",
      "4": "Digital-first government.",
      "5": "Invisible, proactive government."
    },
    D2: {
      "1": "No sandboxes; illegal to test.",
      "2": "Ad hoc exemptions.",
      "3": "Formal regulatory sandbox.",
      "4": "Multi-sector sandboxes.",
      "5": "Global testbed jurisdiction."
    },
    D3: {
      "1": "No support.",
      "2": "Marketing support only.",
      "3": "Grant support for incubators.",
      "4": "Strategic incubator network.",
      "5": "World-class incubation hubs."
    },
    D4: {
      "1": "Complex grant forms.",
      "2": "Reimbursement based (slow).",
      "3": "Milestone-based grants.",
      "4": "Fast-track funding/Vouchers.",
      "5": "Automated, data-driven funding."
    },
    D5: {
      "1": "Hostile to foreign talent.",
      "2": "Difficult visa process.",
      "3": "Startup Visa program.",
      "4": "Fast-track global talent visas.",
      "5": "We are a talent magnet nation."
    },
    D6: {
      "1": "Poor connectivity/access.",
      "2": "Unreliable infrastructure.",
      "3": "Good connectivity.",
      "4": "Universal high-speed access.",
      "5": "Digital infrastructure is a right."
    },
    D7: {
      "1": "Weak intellectual property laws.",
      "2": "Slow IP registration.",
      "3": "Standard intellectual property protection.",
      "4": "Founder-friendly IP regime.",
      "5": "Global gold standard for IP."
    },
    D8: {
      "1": "No links.",
      "2": "Theory only.",
      "3": "Tech transfer offices.",
      "4": "Deep research commercialization.",
      "5": "Seamless lab-to-market pipes."
    },
    D9: {
      "1": "We follow outdated standards.",
      "2": "We copy others.",
      "3": "We adopt ISO/Global standards.",
      "4": "We participate in setting standards.",
      "5": "We write the global standards."
    }
  },
  L3: {
    D1: {
      "1": "We buy only from giants.",
      "2": "We try to buy small (fail).",
      "3": "We have quotas for SMEs.",
      "4": "We actively procure innovation.",
      "5": "Government is the first customer."
    },
    D2: {
      "1": "No export help.",
      "2": "Trade show booths.",
      "3": "Export grants/training.",
      "4": "Global trade missions.",
      "5": "Embassy-as-sales-office."
    },
    D3: {
      "1": "High capital gains tax.",
      "2": "Neutral tax policy.",
      "3": "Angel tax breaks (SEIS).",
      "4": "Venture capital matching funds.",
      "5": "Tax-free exit zones/incentives."
    },
    D4: {
      "1": "No clustering strategy.",
      "2": "Vague \"hubs\" announced.",
      "3": "Active cluster management.",
      "4": "World-class specialized clusters.",
      "5": "Global category dominance (e.g., artificial intelligence)."
    },
    D5: {
      "1": "Negative reputation.",
      "2": "Unknown reputation.",
      "3": "Regional awareness.",
      "4": "Strong \"Startup Nation\" brand.",
      "5": "Global innovation capital."
    },
    D6: {
      "1": "Regulators block adoption.",
      "2": "Regulators watch and wait.",
      "3": "Regulators clarify rules.",
      "4": "Regulators encourage adoption.",
      "5": "Regulators mandate modernization."
    },
    D7: {
      "1": "No role in connecting.",
      "2": "Networking events.",
      "3": "Digital matchmaking platforms.",
      "4": "Active deal-flow facilitation.",
      "5": "Artificial intelligence-driven ecosystem wiring."
    },
    D8: {
      "1": "No support.",
      "2": "Slow bailouts.",
      "3": "Bridge loans/grants.",
      "4": "Rapid resilience funding.",
      "5": "Antifragile economic buffers."
    },
    D9: {
      "1": "No data.",
      "2": "Job creation stats only.",
      "3": "Startup ecosystem reports.",
      "4": "Real-time ecosystem dashboard.",
      "5": "Predictive economic modeling."
    },
    EiR1: {
      "1": "We pick friends/cronies.",
      "2": "We pick \"safe\" bets.",
      "3": "We support the market mechanism.",
      "4": "We fund the best, neutrally.",
      "5": "We lift the whole tideline."
    },
    EiR2: {
      "1": "Grants sustain failure.",
      "2": "No exit criteria for support.",
      "3": "We monitor viability.",
      "4": "We cut support for zombies.",
      "5": "Support accelerates \"fail fast.\""
    },
    EiR3: {
      "1": "Government replaces private capital.",
      "2": "Government competes with angels.",
      "3": "Government co-invests.",
      "4": "Government catalyzes private capital.",
      "5": "Government de-risks new asset classes."
    },
    EiR4: {
      "1": "Pay-to-play.",
      "2": "Opaque selection.",
      "3": "Audited processes.",
      "4": "Transparent, open ledgers.",
      "5": "Algorithmically fair."
    },
    EiR5: {
      "1": "Ecosystem collapses without grants.",
      "2": "High dependency.",
      "3": "Bridge to independence.",
      "4": "Focus on revenue/equity.",
      "5": "Ecosystem is self-sustaining."
    },
    EiR6: {
      "1": "Application takes months.",
      "2": "Application is painful.",
      "3": "Streamlined application.",
      "4": "One-click support.",
      "5": "Proactive/Automatic support."
    },
    EiR7: {
      "1": "We count registrations (easy).",
      "2": "We count activity.",
      "3": "We count survival.",
      "4": "We count growth/revenue.",
      "5": "We count economic complexity."
    },
    EiR8: {
      "1": "Talent flees the country.",
      "2": "Talent leaves for education.",
      "3": "Talent returns (brain circulation).",
      "4": "Talent stays.",
      "5": "Global talent flocks here."
    },
    EiR9: {
      "1": "Maze of confused programs.",
      "2": "Overlapping initiatives.",
      "3": "Mapped ecosystem.",
      "4": "Unified \"One Stop Shop.\"",
      "5": "User-centric government."
    }
  },
  L4: {
    D1: {
      "1": "No venture capital/PE available.",
      "2": "Early-stage only.",
      "3": "Sovereign Wealth Fund activity.",
      "4": "Deep capital markets.",
      "5": "Global capital hub."
    },
    D2: {
      "1": "No local exchange.",
      "2": "Illiquid local exchange.",
      "3": "Growing local exchange.",
      "4": "Strong secondary markets.",
      "5": "Top-tier global exchange."
    },
    D3: {
      "1": "Skill shortage chokes growth.",
      "2": "University pipelines exist.",
      "3": "Reskilling programs active.",
      "4": "Global talent attraction.",
      "5": "Talent surplus/density."
    },
    D4: {
      "1": "Power/Logistics fail.",
      "2": "Infrastructure struggles with load.",
      "3": "Infrastructure supports growth.",
      "4": "Infrastructure is a competitive edge.",
      "5": "Future-proof smart cities."
    },
    D5: {
      "1": "Big firms penalized.",
      "2": "Complexity increases with size.",
      "3": "Regulatory account managers.",
      "4": "Pro-growth tax/regulatory regimes.",
      "5": "Frictionless scaling."
    },
    D6: {
      "1": "Anti-merger & acquisition; protectionist.",
      "2": "Scrutiny blocks exits.",
      "3": "Balanced competition law.",
      "4": "Merger & acquisition friendly.",
      "5": "Fluid market dynamics."
    },
    D7: {
      "1": "No support.",
      "2": "Trade missions.",
      "3": "Export credit guarantees.",
      "4": "Global soft-landing network.",
      "5": "Diplomatic corps sells for you."
    },
    D8: {
      "1": "We tax/regulate them to death.",
      "2": "We ignore their specific needs.",
      "3": "Dedicated unicorn account teams.",
      "4": "Strategic partnership.",
      "5": "National champions."
    },
    D9: {
      "1": "Corporations are dormant.",
      "2": "Corporations do corporate social responsibility innovation.",
      "3": "Corporations actively pilot.",
      "4": "Corporations acquire/invest.",
      "5": "Open innovation economy."
    }
  },
  L5: {
    D1: {
      "1": "No ROI tracking.",
      "2": "Vanity metrics.",
      "3": "Clear ROI measurement.",
      "4": "Rigorous impact data.",
      "5": "Exceptional value creation."
    },
    D2: {
      "1": "Wasteful spending.",
      "2": "Inefficient allocation.",
      "3": "Good efficiency.",
      "4": "High efficiency.",
      "5": "Exceptional efficiency."
    },
    D3: {
      "1": "No portfolio management.",
      "2": "Ad hoc investments.",
      "3": "Managed portfolio.",
      "4": "Optimized portfolio.",
      "5": "Legendary portfolio management."
    },
    D4: {
      "1": "Subsidies create dependency.",
      "2": "Some dependency issues.",
      "3": "Balanced support.",
      "4": "Support drives independence.",
      "5": "Self-sustaining ecosystem."
    },
    D5: {
      "1": "Programs fail to scale.",
      "2": "Limited scalability.",
      "3": "Good scalability.",
      "4": "High scalability.",
      "5": "Exceptional scalability."
    },
    D6: {
      "1": "No shared infrastructure.",
      "2": "Limited shared resources.",
      "3": "Good shared platforms.",
      "4": "Strong shared services.",
      "5": "Exceptional ecosystem infrastructure."
    },
    D7: {
      "1": "No innovation accounting.",
      "2": "Basic metrics.",
      "3": "Good innovation metrics.",
      "4": "Comprehensive metrics.",
      "5": "Predictive innovation accounting."
    },
    D8: {
      "1": "Heavy bureaucracy.",
      "2": "Slow processes.",
      "3": "Streamlined processes.",
      "4": "Agile governance.",
      "5": "Trust-based governance."
    },
    D9: {
      "1": "No asset leverage.",
      "2": "Underutilized assets.",
      "3": "Good asset utilization.",
      "4": "Strategic asset deployment.",
      "5": "Assets as competitive advantage."
    }
  },
  L6: {
    D1: {
      "1": "No innovation leadership.",
      "2": "Junior leadership.",
      "3": "VP-level leadership.",
      "4": "C-suite leadership.",
      "5": "Head of State champions innovation."
    },
    D2: {
      "1": "No innovation culture.",
      "2": "Pockets of innovation.",
      "3": "Growing culture.",
      "4": "Strong culture.",
      "5": "Innovation is the national identity."
    },
    D3: {
      "1": "No strategic vision.",
      "2": "Reactive policy.",
      "3": "Proactive policy.",
      "4": "Strategic policy.",
      "5": "Visionary policy leadership."
    },
    D4: {
      "1": "No ecosystem role.",
      "2": "Participant.",
      "3": "Active member.",
      "4": "Ecosystem leader.",
      "5": "Global ecosystem architect."
    },
    D5: {
      "1": "Siloed government.",
      "2": "Limited coordination.",
      "3": "Good coordination.",
      "4": "Strong coordination.",
      "5": "Whole-of-government innovation."
    },
    D6: {
      "1": "Fear-based culture.",
      "2": "Risk-averse culture.",
      "3": "Risk-tolerant culture.",
      "4": "Risk-embracing culture.",
      "5": "Fearless innovation culture."
    },
    D7: {
      "1": "No talent development.",
      "2": "Limited training.",
      "3": "Good talent programs.",
      "4": "Strong talent development.",
      "5": "World-class innovation talent."
    },
    D8: {
      "1": "No innovation mission.",
      "2": "Vague mission.",
      "3": "Clear mission.",
      "4": "Compelling mission.",
      "5": "Inspiring national mission."
    },
    D9: {
      "1": "No global influence.",
      "2": "Limited influence.",
      "3": "Regional influence.",
      "4": "Global influence.",
      "5": "Global innovation leader."
    }
  },
  L7: {
    D1: {
      "1": "No unicorns produced.",
      "2": "A few unicorns.",
      "3": "Several unicorns.",
      "4": "Many unicorns.",
      "5": "Legendary unicorn factory."
    },
    D2: {
      "1": "No legacy.",
      "2": "Short-term legacy.",
      "3": "Growing legacy.",
      "4": "Strong legacy.",
      "5": "Generational legacy."
    },
    D3: {
      "1": "No societal impact.",
      "2": "Minor impact.",
      "3": "Noticeable impact.",
      "4": "Major impact.",
      "5": "Transformative societal impact."
    },
    D4: {
      "1": "No inspiration.",
      "2": "Occasionally inspiring.",
      "3": "Regularly inspiring.",
      "4": "Consistently inspiring.",
      "5": "Legendary inspiration source."
    },
    D5: {
      "1": "Local only.",
      "2": "Regional presence.",
      "3": "National presence.",
      "4": "International presence.",
      "5": "Global innovation hub."
    },
    D6: {
      "1": "No disruption enabled.",
      "2": "Minor disruption.",
      "3": "Some disruption.",
      "4": "Major disruption.",
      "5": "Industry-defining disruption."
    },
    D7: {
      "1": "No standards set.",
      "2": "Following standards.",
      "3": "Meeting standards.",
      "4": "Setting standards.",
      "5": "Defining global standards."
    },
    D8: {
      "1": "No ecosystem.",
      "2": "Basic ecosystem.",
      "3": "Growing ecosystem.",
      "4": "Strong ecosystem.",
      "5": "World-class ecosystem."
    },
    D9: {
      "1": "No systemic change.",
      "2": "Minor change.",
      "3": "Some systemic change.",
      "4": "Major systemic change.",
      "5": "Permanent systemic change."
    }
  },
  L8: {
    D1: {
      "1": "Extractive policies.",
      "2": "Compliance focus.",
      "3": "Responsible policies.",
      "4": "Stewardship mindset.",
      "5": "Regenerative policies."
    },
    D2: {
      "1": "GDP only.",
      "2": "Some broader metrics.",
      "3": "Balanced value measurement.",
      "4": "Stakeholder value focus.",
      "5": "Wellbeing economy."
    },
    D3: {
      "1": "Extractive practices.",
      "2": "Compliance sustainability.",
      "3": "Proactive sustainability.",
      "4": "Sustainability by design.",
      "5": "Regenerative practices."
    },
    D4: {
      "1": "No social focus.",
      "2": "Token social programs.",
      "3": "Clear social strategy.",
      "4": "Strong social impact.",
      "5": "Transformative social change."
    },
    D5: {
      "1": "Opaque governance.",
      "2": "Basic transparency.",
      "3": "Good governance.",
      "4": "Strong governance.",
      "5": "Radical transparency."
    },
    D6: {
      "1": "Corruption prevalent.",
      "2": "Compliance ethics.",
      "3": "Good ethics.",
      "4": "Strong ethics.",
      "5": "Moral leadership."
    },
    D7: {
      "1": "Exploits communities.",
      "2": "Transactional relations.",
      "3": "Good partnership.",
      "4": "Strong community integration.",
      "5": "Transformative community empowerment."
    },
    D8: {
      "1": "Election-cycle thinking.",
      "2": "Annual planning.",
      "3": "5–10 year planning.",
      "4": "Multi-decade planning.",
      "5": "Seven-generation thinking."
    },
    D9: {
      "1": "Values as rhetoric.",
      "2": "Values stated.",
      "3": "Values practiced.",
      "4": "Values enforced.",
      "5": "Values are national identity."
    }
  }
};

let updateCount = 0;
let missingCount = 0;

for (const [levelId, dimensions] of Object.entries(allUpdates)) {
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId]) {
      console.log(`Missing level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions) {
      console.log(`Missing questions in level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId]) {
      console.log(`Missing dimension: ${levelId} ${dimId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders) {
      answerKeys[levelId].questions[dimId].stakeholders = {};
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER]) {
      answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER] = {
        question: "",
        grades: {}
      };
    }
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER];
    if (!stakeholderData.grades) {
      stakeholderData.grades = {};
    }
    
    for (const [grade, answer] of Object.entries(grades)) {
      stakeholderData.grades[grade] = answer;
    }
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId} (5 grades)`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Government/Policy entries with all 5 grades.`);
console.log(`⚠️ Missing entries: ${missingCount}`);
console.log(`Total individual grade updates: ${updateCount * 5}`);
console.log(`File saved to: ${answerKeysPath}`);
