const fs = require('fs');
const path = require('path');

const csvFile = path.join(__dirname, '../attached_assets/L0-8_FirstPerson_1766519191019.txt');
const jsonFile = path.join(__dirname, '../client/src/lib/answerKeys.json');

const stakeholderMap = {
  'Startup': 'Startup (Founder)',
  'Investor': 'Investor',
  'Corporate': 'Corporate Partner',
  'Accelerator': 'Enabler (Accelerator)',
  'Services': 'Facilitator (Services)',
  'Government': 'Government/Policy',
  'Media': 'Influencer/Media',
  'Mentor': 'Mentor',
  'Talent': 'Professional (Talent)'
};

const stakeholderOrder = ['Startup', 'Investor', 'Corporate', 'Accelerator', 'Services', 'Government', 'Media', 'Mentor', 'Talent'];

function parseCSVLine(line) {
  const result = [];
  let current = '';
  let inQuotes = false;
  
  for (let i = 0; i < line.length; i++) {
    const char = line[i];
    if (char === '"') {
      inQuotes = !inQuotes;
    } else if (char === ',' && !inQuotes) {
      result.push(current.trim());
      current = '';
    } else {
      current += char;
    }
  }
  result.push(current.trim());
  return result;
}

function main() {
  const csvContent = fs.readFileSync(csvFile, 'utf8');
  const lines = csvContent.split('\n').filter(l => l.trim());
  
  const existingJson = JSON.parse(fs.readFileSync(jsonFile, 'utf8'));
  
  let currentLevel = null;
  let currentCode = null;
  let gradeDescriptions = {};
  
  for (let i = 1; i < lines.length; i++) {
    const fields = parseCSVLine(lines[i]);
    
    if (fields[0] && fields[0].startsWith('L')) {
      currentLevel = fields[0];
      currentCode = fields[4];
      gradeDescriptions = {};
    } else if (fields[4] && fields[4].startsWith('Grade')) {
      const gradeNum = fields[4].replace('Grade ', '');
      
      stakeholderOrder.forEach((stakeholder, idx) => {
        const colIdx = 7 + idx;
        const description = fields[colIdx];
        if (description) {
          if (!gradeDescriptions[stakeholder]) {
            gradeDescriptions[stakeholder] = {};
          }
          gradeDescriptions[stakeholder][gradeNum] = description;
        }
      });
      
      if (gradeNum === '5' && currentLevel && currentCode) {
        const mappedStakeholder = stakeholderMap;
        
        if (existingJson[currentLevel] && 
            existingJson[currentLevel].questions && 
            existingJson[currentLevel].questions[currentCode]) {
          
          stakeholderOrder.forEach((stakeholder) => {
            const targetStakeholder = stakeholderMap[stakeholder];
            if (existingJson[currentLevel].questions[currentCode].stakeholders[targetStakeholder] &&
                gradeDescriptions[stakeholder]) {
              
              Object.keys(gradeDescriptions[stakeholder]).forEach(grade => {
                existingJson[currentLevel].questions[currentCode].stakeholders[targetStakeholder].grades[grade] = 
                  gradeDescriptions[stakeholder][grade];
              });
            }
          });
        }
      }
    }
  }
  
  fs.writeFileSync(jsonFile, JSON.stringify(existingJson, null, 2));
  console.log('Updated answerKeys.json with first-person descriptions');
}

main();
