# i2u.ai Value Hub

## Overview

This is a full-stack web application for i2u.ai (Ideas to Unicorns through AI), a startup insights and assessment platform. The application provides unicorn case studies, value calculators, and startup assessment tools. It features a React frontend with a modern component library and an Express backend with PostgreSQL database storage.

The core purpose is to deliver credibility through real unicorn success stories woven into startup growth phases, enabling users to assess their startup readiness and understand value delivery through proven case studies.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **Framework**: React 18 with TypeScript
- **Routing**: Wouter (lightweight React router)
- **State Management**: TanStack React Query for server state
- **Styling**: Tailwind CSS v4 with CSS variables for theming
- **Component Library**: shadcn/ui (New York style) with Radix UI primitives
- **Build Tool**: Vite with custom plugins for Replit integration
- **Fonts**: Inter (body) and Space Grotesk (headings)

The frontend follows a feature-based structure with pages, components, and lib directories. Dark mode is enabled by default via the `dark` class on the body element.

### Backend Architecture
- **Runtime**: Node.js with Express
- **Language**: TypeScript with ESM modules
- **API Pattern**: RESTful endpoints under `/api` prefix
- **Development**: tsx for TypeScript execution, Vite dev server for HMR

The server handles API routes and serves the static frontend build in production. Development mode uses Vite middleware for hot module replacement.

### Data Storage
- **Database**: PostgreSQL via Drizzle ORM
- **Schema Location**: `shared/schema.ts` (shared between frontend and backend)
- **Migrations**: Drizzle Kit with `db:push` command
- **Connection**: postgres.js client with connection pooling

Current schema includes:
- `users`: Basic authentication table with UUID primary keys
- `assessments`: Startup assessment results with JSONB answers, scores, and metadata
- `userAssessmentProgress`: Tracks permanent stakeholder choice, total gleams/alicorns, and pause state
- `levelCompletions`: Records individual level completions with timestamps, IP addresses, and scores
- `userIdeas`: Multiple startup ideas per user with name, description, sector, stage
- `ideaRoles`: Links stakeholder roles to specific ideas (e.g., founder for Idea A, mentor for Idea B)
- `assessmentSessions`: Tracks assessment progress per idea+role+level combination with pause state
- `userSessions`: Anonymous session tracking with IP and microsecond timestamps for magic link auth

## Privacy-First Magic Link Authentication

### How It Works
- Users remain fully anonymous by default
- Each session is tracked with:
  - SessionId (stored in localStorage)
  - IP address at creation time
  - Microsecond-precision timestamp (e.g., `2025-12-25T15:42:33.847293Z`)
- No email or password required

### Two Ways to Access Your Account
1. **Magic Link** (primary): `/m/:sessionId` - Click link, instant access
2. **IP + Timestamp** (backup): Enter IP and approximate creation time to recover

### Data Ownership
- Users can store unlimited ideas
- Export all data as JSON or human-readable summary
- Delete all data from system at any time
- Clear messaging about data rights on Account page

### API Endpoints for Session Management
- `POST /api/user-sessions` - Create or get session with microsecond timestamp
- `GET /api/user-sessions/:sessionId` - Validate magic link
- `POST /api/user-sessions/login` - Login with IP + Timestamp credentials
- `GET /api/user-data/:sessionId/export` - Export all user data
- `DELETE /api/user-data/:sessionId` - Delete all user data (requires confirmation)

## Multi-Idea & Multi-Role System

### Multiple Ideas
- Users can have multiple startup ideas
- Each idea has a name, description, sector, and stage
- Switch between ideas during assessment without losing progress
- Ideas persist across sessions

### Multiple Stakeholder Roles
- Same person can have different roles for different ideas
- Example: Founder for "My SaaS", Mentor for "Friend's Startup", Investor exploring market
- 9 stakeholder types: founder, mentor, investor, talent, enabler, corporate, academic, government, media
- Roles are linked to specific ideas

### Enhanced Exit/Pause System
- AssessmentExitModal provides exit options during assessment
- Options include:
  - Take a Break: 2 min to 12 hours with timer
  - Schedule Return: Set specific date/time to continue
  - Switch Idea: Jump to a different startup idea
  - Switch Role: Assess from a different stakeholder perspective
  - Just Exit: Save progress and return whenever ready
- All progress saved with timestamp and question index

### Context Switching
- ContextSwitcher component for managing ideas and roles
- Create new ideas on the fly
- Add new roles to existing ideas
- Resume paused assessments from any idea/role context

### API Endpoints for Multi-Idea System
- `GET /api/ideas/:sessionId` - Get all user's ideas
- `POST /api/ideas` - Create new idea
- `PUT /api/ideas/:id` - Update idea
- `GET /api/roles/:sessionId` - Get all roles across ideas
- `POST /api/roles` - Add role to idea
- `GET /api/assessment-sessions/:sessionId` - Get all assessment sessions
- `POST /api/assessment-sessions` - Create new session
- `PUT /api/assessment-sessions/:id` - Update session (pause/resume/complete)

## Returning User Features

### Progress Tracking
- Authenticated users have their progress persisted across sessions
- Stakeholder choice is permanent once selected (can request additional stakeholders later)
- Level completions tracked with timestamp and IP address for audit trail
- UserProgressPanel component displays history for returning users

### Pause/Break Mechanism
- Users can pause assessments during any question
- Break durations: 2 min to 12 hours with alarm functionality
- PauseBreakModal for selecting break duration
- BreakCountdown overlay with resume/extend options
- Pause state persisted to database for cross-session continuity

### API Endpoints for Progress
- `GET /api/value-journey/progress/:userId` - Get user progress and completions
- `POST /api/value-journey/progress` - Create initial progress with stakeholder
- `POST /api/value-journey/completions` - Save level completion with IP tracking
- `PUT /api/value-journey/progress/:userId/pause` - Update pause state
- `POST /api/value-journey/progress/:userId/request-stakeholder` - Request additional stakeholder

## Value Journey Quest Scoring System

### Gleams & Alicorns
The platform uses a gamified scoring system with NO percentages anywhere:
- **Gleams (✨)**: Points earned per parameter, defined in the matrix data
  - L0 parameters: 10 Gleams max each
  - L1+ parameters: 100 Gleams max each
  - Calculated using `calculateGleams(answers, level)` from `valueJourneyTypes.ts`
- **Alicorns (🦄)**: Achievement badges/tokens earned alongside Gleams
  - Calculated using `calculateAlicorns(answers, level)`
  - Display format: decimal with 2 places (e.g., 3.45 Alicorns)

### Important Implementation Notes
- NEVER use percentage scores for display - always use Gleams/Alicorns
- `totalGleams` state variable tracks cumulative Gleams across all completed levels
- Share data encodes `{score, gleams, alicorns, level, aspirational, stakeholder}`
- All mock/illustration data must be labeled with "Illustration purposes"

### Build System
- **Client Build**: Vite outputs to `dist/public`
- **Server Build**: esbuild bundles server code to `dist/index.cjs`
- **Bundling Strategy**: Selected dependencies are bundled to reduce cold start times

## External Dependencies

### Database
- PostgreSQL database (required via `DATABASE_URL` environment variable)
- Drizzle ORM for type-safe database operations
- connect-pg-simple for session storage capability

### UI/Component Libraries
- Radix UI primitives (comprehensive set for dialogs, menus, forms, etc.)
- shadcn/ui component patterns
- Lucide React for icons
- Embla Carousel for carousel functionality
- cmdk for command palette
- react-day-picker for calendar/date selection
- recharts for data visualization
- vaul for drawer components

### Form & Validation
- React Hook Form with Zod resolvers
- Zod for schema validation
- drizzle-zod for database schema to Zod schema conversion

### Replit-Specific Integrations
- @replit/vite-plugin-runtime-error-modal for error display
- @replit/vite-plugin-cartographer for development tooling
- @replit/vite-plugin-dev-banner for development indicators
- Custom meta images plugin for OpenGraph image handling

### Utilities
- date-fns for date formatting
- class-variance-authority and clsx for conditional styling
- tailwind-merge for Tailwind class merging
- nanoid for unique ID generation